// ADVList.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "ADVList.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CADVList dialog


CADVList::CADVList(CWnd* pParent /*=NULL*/)
	: CDialog(CADVList::IDD, pParent)
{
	//{{AFX_DATA_INIT(CADVList)
	m_AcctID = _T("");
	m_DeviceType = _T("");
	m_HWDeviceID = _T("");
	m_DeviceName = _T("");
	//}}AFX_DATA_INIT
}
CADVList ::CADVList(IApplication *pApp):CDialog(CADVList::IDD, NULL)
{
	pApplication = pApp;
	pHwDevice.CreateInstance(__uuidof(HWDevice));
	
	
}

void CADVList::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CADVList)
	DDX_Control(pDX, IDC_DEVNAME, m_Cnt_DevName);
	DDX_Control(pDX, IDC_HWDEVID, m_Cnt_HWDevID);
	DDX_Control(pDX, IDC_DEVTYPE, m_Cnt_DevType);
	DDX_Control(pDX, IDC_ACCTID, m_cnt_AcctID);
	DDX_Control(pDX, IDC_HIDLIST, m_HIDlist);
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	DDX_Control(pDX, IDC_ADVLIST, m_AdvList);
	DDX_Text(pDX, IDC_ACCTID, m_AcctID);
	DDX_Text(pDX, IDC_DEVTYPE, m_DeviceType);
	DDX_Text(pDX, IDC_HWDEVID, m_HWDeviceID);
	DDX_Text(pDX, IDC_DEVNAME, m_DeviceName);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CADVList, CDialog)
	//{{AFX_MSG_MAP(CADVList)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	ON_CBN_SELCHANGE(IDC_HIDLIST, OnSelchangeHidlist)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CADVList message handlers
BOOL CADVList::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	LoadcolumnHeaders();
	LoadAccounts();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE

}
void CADVList ::LoadcolumnHeaders()
{
	m_AdvList.InsertColumn(0,_T("HID"),LVCFMT_LEFT,100);
	m_AdvList.InsertColumn(1,_T("DeviceName"),LVCFMT_LEFT,200);
	m_AdvList.InsertColumn(2,_T("DeviceDescription"),LVCFMT_LEFT,200);
	m_AdvList.InsertColumn(3,_T("DeviceType"),LVCFMT_LEFT,100);
	m_AdvList.InsertColumn(4,_T("HWDeviceID"),LVCFMT_LEFT,100);

	// Update for Selecting Full Row -- Guru
	m_AdvList.SetExtendedStyle(LVS_EX_FULLROWSELECT);

}
void CADVList :: LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				m_AcctList.AddString(pAccount->AccountName);
				pAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	//m_AcctList.SetCurSel(0);
}


void CADVList::OnSelchangeAcctlist() 
{
		m_HIDlist.ResetContent();
		m_Cnt_DevName.SetWindowText(L"");
		m_Cnt_DevType.SetWindowText(L"");
		m_cnt_AcctID.SetWindowText(L"");
		m_Cnt_HWDevID.SetWindowText(L"");
		GetHIDDetails();	
	
		m_AdvList.DeleteAllItems();
		BSTR bstrAcctName;
		//CString DeviceName ,DeviceID ,DeviceDesc, DeviceType;
		CStringArray sAdvArray;
		//select account name 
		int index_Account = m_AcctList.GetCurSel();
		CString sAcctName;
		if (index_Account <0)
			bstrAcctName = SysAllocString(L"");
		else
		{
			m_AcctList.GetLBText(index_Account,sAcctName);
			bstrAcctName = sAcctName.AllocSysString();
		}
		_variant_t vAdvs;
		vAdvs.Clear();

	
		pApplication->GetADVDetailsByAccountName(bstrAcctName,&vAdvs);
		
		if(vAdvs.vt == VT_EMPTY)
		{
			AfxMessageBox(L"No Device Configured");
			return;
		}
		
		long uBound =0 ;
		IDispatch *pDisp = NULL;   //   
		
		COleSafeArray sa(vAdvs);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
		{
			IHWDevice *pDevice = NULL;
			///IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IHWDevice,(void**)&pDevice);
			if (pDevice != NULL)
			{
				CString sDeviceID;
				sDeviceID.Format(L"%ld",pDevice->DeviceID);
				sAdvArray.Add(sDeviceID); 
				sAdvArray.Add(pDevice->DeviceName);
				sAdvArray.Add(pDevice->DeviceDesc);
				CString sDeviceType;
				sDeviceType.Format(L"%ld",pDevice->DeviceType);
				sAdvArray.Add(sDeviceType);
				CString sHWDeviceID;
				sHWDeviceID.Format(L"%ld",pDevice->HWDeviceID);
				sAdvArray.Add(sHWDeviceID);
				
				pDevice->Release();
			}
			long l = sAdvArray.GetSize();
			LVITEM lv;
			lv.mask=LVIF_TEXT;
			lv.iItem=i;
			lv.iSubItem=0;
			CString sFirStr = sAdvArray.GetAt(0);
			//AfxMessageBox(sFirStr);
			//AfxMessageBox(sFirStr);
			lv.pszText=sFirStr.GetBuffer(sFirStr.GetLength());
			::SendMessage(m_AdvList.m_hWnd,LVM_INSERTITEM,0,(LPARAM)&lv);

			for(int k=1;k<5;k++)
			{ 
               
				lv.iSubItem=k;
				CString sSubitem =sAdvArray.GetAt(k);
			//	AfxMessageBox(sSubitem);
				lv.pszText= sSubitem.GetBuffer(sSubitem.GetLength());
				::SendMessage(m_AdvList.m_hWnd,LVM_SETITEM,0,(LPARAM)&lv);
			}
			long lcount = sAdvArray.GetSize();

			sAdvArray.RemoveAll();
			
		}
		
	pDisp->Release();

}
void CADVList:: GetHIDDetails()
{
		BSTR bstrAcctName;
		//select account name 
		int index_Account = m_AcctList.GetCurSel();
		CString sAcctName;
		if (index_Account <0)
			bstrAcctName = SysAllocString(L"");
		else
		{
			m_AcctList.GetLBText(index_Account,sAcctName);
			bstrAcctName = sAcctName.AllocSysString();
		}
		_variant_t vAdvs;
		vAdvs.Clear();
		pApplication->GetADVDetailsByAccountName(bstrAcctName,&vAdvs);
		
		if(vAdvs.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		
		IDispatch *pDisp = NULL;
		COleSafeArray sa(vAdvs);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IHWDevice *pDevice = NULL;
			
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IHWDevice,(void**)&pDevice);
			if (pDevice != NULL)
			{
				CString sDeviceID;
				sDeviceID.Format(L"%ld",pDevice->DeviceID);
				m_HIDlist.AddString(sDeviceID);
				pDevice->Release();
			}
			//pDisp->Release();
		}
	UpdateData(FALSE);
	pDisp->Release();
}
void CADVList ::GetDeviceDetails()
{
	
		//select CHID
		int index_HID = m_HIDlist.GetCurSel();
		CString sHid;
		m_HIDlist.GetLBText(index_HID,sHid);
		long lHID = _wtoi(sHid);

		// Getparticular card holder details
		_variant_t vDevice;
		vDevice.Clear();
		pApplication->GetADVDetailsByHID(lHID,&vDevice);
		
		if(vDevice.vt ==  VT_EMPTY)
		{
			return;
		}
		UpdateData(TRUE);
		if( vDevice.vt & VT_DISPATCH)
		{
			
			IHWDevicePtr pHWDevice(vDevice.pdispVal);
			m_DeviceName =CString(((LPWSTR)pHWDevice->DeviceName));
			CString sAccountID;
			sAccountID.Format(L"%ld",pHWDevice->AccountID);
			m_AcctID = sAccountID;
			CString sDeviceType;
			sDeviceType.Format(L"%ld",pHWDevice->DeviceType);
			m_DeviceType = sDeviceType;
			CString sHWDeviceID;
			sHWDeviceID.Format(L"%ld",pHWDevice->HWDeviceID);
			m_HWDeviceID = sHWDeviceID;			
		}
		UpdateData(FALSE);
		if(NULL != vDevice.pdispVal)
		{
			//vCH.pdispVal->Release();
			vDevice.Clear();
		}
		
}

void CADVList::OnSelchangeHidlist() 
{

	
	GetDeviceDetails();
	int index_Hid = m_HIDlist.GetCurSel();
	CString sHid;

	m_HIDlist.GetLBText(index_Hid,sHid);
	long lHID = _wtoi(sHid);

	long lAccountID;
	pApplication->GetAcctIDByHID(lHID,&lAccountID);
	UpdateData(TRUE);	
	UpdateData(FALSE);
	
}
